PROC TABULATE DATA=ghpb15 NOSEPS MISSING ORDER=DATA;
CLASS  ENT2 health_type / PRELOADFMT MLF;
LABEL SUBTL_ACT_RTD_SEP_CNE="Total Participants (thousands)"
	  TOT_ACTIVE_PARTCP_CNE="Active Participants (thousands)"
	  TOT_ASSETS_EOY_AME="Total Assets (millions)"
	  TOT_CONTRIB_AME="Total Contributions (millions)"
	  TOT_DISTRIB_BNFT_AME="Total Benefits (millions)";
VAR TOT_ACTIVE_PARTCP_CNE TOT_ASSETS_EOY_AME SUBTL_ACT_RTD_SEP_CNE TOT_ACTIVE_PARTCP_CNE / WEIGHT=DUP_WGT;
VAR TOT_CONTRIB_AME TOT_DISTRIB_BNFT_AME;
VAR DUP_WGT;
TITLE 'Table A1.  Number of Group Health Plans, Total Participants, Active Participants,';
TITLE2 'Assets, Contributions, and Benefits';
TITLE3 'by type of plan and type of insurance, 2015';
TITLE4 'All Plans';
KEYLABEL ALL='Total';
TABLE ALL health_type=' ', 
    SUM=' '*DUP_WGT='Number of Plans'*F=COMMA13. (SUM=' '*(SUBTL_ACT_RTD_SEP_CNE TOT_ACTIVE_PARTCP_CNE))*F=K13F.
	SUM=' '*(TOT_ASSETS_EOY_AME TOT_CONTRIB_AME TOT_DISTRIB_BNFT_AME)*F=m13f_2stars. / 
    RTS=41 Box='Type of Plan'  MISSTEXT='-';

RUN;

PROC TABULATE DATA=ghpb15 NOSEPS MISSING ORDER=DATA;
where INS3=0;
CLASS ENT2 health_type / PRELOADFMT MLF;
LABEL 
	SUBTL_ACT_RTD_SEP_CNE="Total Participants (thousands)"
	  TOT_ACTIVE_PARTCP_CNE="Active Participants (thousands)"
	  TOT_ASSETS_EOY_AME="Total Assets (millions)"
	  TOT_CONTRIB_AME="Total Contributions (millions)"
	  TOT_DISTRIB_BNFT_AME="Total Benefits (millions)";
VAR TOT_ACTIVE_PARTCP_CNE TOT_ASSETS_EOY_AME SUBTL_ACT_RTD_SEP_CNE TOT_ACTIVE_PARTCP_CNE / WEIGHT=DUP_WGT;
VAR TOT_CONTRIB_AME TOT_DISTRIB_BNFT_AME;
VAR DUP_WGT;
TITLE 'Table A1.  Number of Group Health Plans, Total Participants, Active Participants,';
TITLE2 'Assets, Contributions, and Benefits';
TITLE3 'by type of plan and type of insurance, 2015';
TITLE4 'Self-Insured';
KEYLABEL ALL='Total';
TABLE ALL health_type=' ', 
    SUM=' '*DUP_WGT='Number of Plans'*F=COMMA13. (SUM=' '*(SUBTL_ACT_RTD_SEP_CNE TOT_ACTIVE_PARTCP_CNE))*F=K13F.
	SUM=' '*(TOT_ASSETS_EOY_AME TOT_CONTRIB_AME TOT_DISTRIB_BNFT_AME)*F=m13f_2stars. / 
    RTS=41 Box='Type of Plan'  MISSTEXT='-';

RUN;

PROC TABULATE DATA=ghpb15 NOSEPS MISSING ORDER=DATA;
where INS3=1;
CLASS ENT2 health_type / PRELOADFMT MLF;
LABEL SUBTL_ACT_RTD_SEP_CNE="Total Participants (thousands)"
	  TOT_ACTIVE_PARTCP_CNE="Active Participants (thousands)"
	  TOT_ASSETS_EOY_AME="Total Assets (millions)"
	  TOT_CONTRIB_AME="Total Contributions (millions)/"
	  TOT_DISTRIB_BNFT_AME="Total Benefits (millions)";
VAR TOT_ACTIVE_PARTCP_CNE TOT_ASSETS_EOY_AME SUBTL_ACT_RTD_SEP_CNE TOT_ACTIVE_PARTCP_CNE / WEIGHT=DUP_WGT;
VAR TOT_CONTRIB_AME TOT_DISTRIB_BNFT_AME;
VAR DUP_WGT;
TITLE 'Table A1.  Number of Group Health Plans, Total Participants, Active Participants,';
TITLE2 'Assets, Contributions, and Benefits';
TITLE3 'by type of plan and type of insurance, 2015';
TITLE4 'Mixed-Insured';
KEYLABEL ALL='Total';
TABLE ALL health_type=' ', 
    SUM=' '*DUP_WGT='Number of Plans'*F=COMMA13. (SUM=' '*(SUBTL_ACT_RTD_SEP_CNE TOT_ACTIVE_PARTCP_CNE))*F=K13F.
	SUM=' '*(TOT_ASSETS_EOY_AME TOT_CONTRIB_AME TOT_DISTRIB_BNFT_AME)*F=m13f_2stars. / 
    RTS=41 Box='Type of Plan'  MISSTEXT='-';

RUN;

PROC TABULATE DATA=ghpb15 NOSEPS MISSING ORDER=DATA;
where INS3=2;
CLASS ENT2 health_type / PRELOADFMT MLF;
LABEL SUBTL_ACT_RTD_SEP_CNE="Total Participants (thousands)"
	  TOT_ACTIVE_PARTCP_CNE="Active Participants (thousands)"
	  TOT_ASSETS_EOY_AME="Total Assets (millions)"
	  TOT_CONTRIB_AME="Total Contributions (millions)"
	  TOT_DISTRIB_BNFT_AME="Total Benefits (millions)";
VAR TOT_ACTIVE_PARTCP_CNE TOT_ASSETS_EOY_AME SUBTL_ACT_RTD_SEP_CNE TOT_ACTIVE_PARTCP_CNE / WEIGHT=DUP_WGT;
VAR TOT_CONTRIB_AME TOT_DISTRIB_BNFT_AME ;
VAR DUP_WGT;
TITLE 'Table A1.  Number of Group Health Plans, Total Participants, Active Participants,';
TITLE2 'Assets, Contributions, and Benefits';
TITLE3 'by type of plan and type of insurance, 2015';
TITLE4 'Fully-Insured';
KEYLABEL ALL='Total';
TABLE ALL health_type=' ', 
    SUM=' '*DUP_WGT='Number of Plans'*F=COMMA13. (SUM=' '*(SUBTL_ACT_RTD_SEP_CNE TOT_ACTIVE_PARTCP_CNE))*F=K13F.
	SUM=' '*(TOT_ASSETS_EOY_AME TOT_CONTRIB_AME TOT_DISTRIB_BNFT_AME)*F=m13f_2stars. / 
    RTS=41 Box='Type of Plan'  MISSTEXT='-';

RUN;
